/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.map;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.map.LegendItem;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.screens.DungeonMapScreen;
import java.util.ArrayList;

public class Legend {
    private static final float X = 1670.0f * Settings.scale;
    private static final float Y = 500.0f * Settings.scale;
    private static final int LW = 512;
    public Color c = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("Legend");
    public static final String[] TEXT = Legend.uiStrings.TEXT;
    private ArrayList<LegendItem> items = new ArrayList();

    public Legend() {
        this.items.add(new LegendItem(TEXT[0], ImageMaster.MAP_NODE_EVENT, TEXT[1], TEXT[2], 0));
        this.items.add(new LegendItem(TEXT[3], ImageMaster.MAP_NODE_MERCHANT, TEXT[4], TEXT[5], 1));
        this.items.add(new LegendItem(TEXT[6], ImageMaster.MAP_NODE_TREASURE, TEXT[7], TEXT[8], 2));
        this.items.add(new LegendItem(TEXT[9], ImageMaster.MAP_NODE_REST, TEXT[10], TEXT[11], 3));
        this.items.add(new LegendItem(TEXT[12], ImageMaster.MAP_NODE_ENEMY, TEXT[13], TEXT[14], 4));
        this.items.add(new LegendItem(TEXT[15], ImageMaster.MAP_NODE_ELITE, TEXT[16], TEXT[17], 5));
    }

    public void update(float mapAlpha, boolean isMapScreen) {
        if (mapAlpha >= 0.8f && isMapScreen) {
            this.c.a = MathHelper.fadeLerpSnap(this.c.a, 1.0f);
            for (LegendItem i : this.items) {
                i.update();
            }
        } else {
            this.c.a = MathHelper.fadeLerpSnap(this.c.a, 0.0f);
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.c);
        sb.draw(ImageMaster.MAP_LEGEND, X - 256.0f, Y - 400.0f - DungeonMapScreen.offsetY / 50.0f, 256.0f, 400.0f, 512.0f, 800.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 512, 800, false, false);
        Color c2 = new Color(MapRoomNode.AVAILABLE_COLOR.r, MapRoomNode.AVAILABLE_COLOR.g, MapRoomNode.AVAILABLE_COLOR.b, this.c.a);
        FontHelper.renderFontCentered(sb, FontHelper.menuBannerFont, TEXT[18], X, Y + 170.0f * Settings.scale - DungeonMapScreen.offsetY / 50.0f, c2);
        sb.setColor(c2);
        for (LegendItem i : this.items) {
            i.render(sb, c2);
        }
    }
}

